/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.models.bakedmodels;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.blocks.BlockBonsaiPot;
import com.ferreusveritas.dynamictrees.blocks.SpeciesProperty;
import com.ferreusveritas.dynamictrees.client.QuadManipulator;
import com.ferreusveritas.dynamictrees.models.bakedmodels.BakedModelSapling;
import com.ferreusveritas.dynamictrees.trees.Species;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BakedModelBlockBonsaiPot
implements IBakedModel {
    protected IBakedModel basePotModel;
    protected Map<Species, List<BakedQuad>> cachedSaplingQuads = new HashMap<Species, List<BakedQuad>>();

    public BakedModelBlockBonsaiPot(IBakedModel basePotModel) {
        this.basePotModel = basePotModel;
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (side != null) {
            return quads;
        }
        Species species = Species.NULLSPECIES;
        IBlockState potState = null;
        if (state != null && state.func_177230_c() instanceof BlockBonsaiPot && state instanceof IExtendedBlockState) {
            species = (Species)((Object)((IExtendedBlockState)state).getValue((IUnlistedProperty)SpeciesProperty.SPECIES));
            potState = (IBlockState)((IExtendedBlockState)state).getValue((IUnlistedProperty)BlockBonsaiPot.POT);
        }
        if (species == null || species == Species.NULLSPECIES || !(potState.func_177230_c() instanceof BlockFlowerPot)) {
            return quads;
        }
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        IBakedModel potModel = dispatcher.func_184389_a(potState);
        IBakedModel saplingModel = BakedModelSapling.getModelForSapling(species);
        quads.addAll(potModel.func_188616_a(potState, side, rand));
        quads.addAll(this.cachedSaplingQuads.computeIfAbsent(species, s -> QuadManipulator.getQuads(saplingModel, ModBlocks.blockDynamicSapling.func_176223_P(), new Vec3d(0.0, 0.25, 0.0), rand)));
        return quads;
    }

    public boolean func_177555_b() {
        return this.basePotModel.func_177555_b();
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return true;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.basePotModel.func_177554_e();
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }
}

